<?php
$pageTitle = "ایجاد حساب کاربری";
$iconUrl = "logo.jpg";
require_once "./components/header.php";
require_once "../../app/controller/admin/UsersController.php";
require_once "../../layouts/admin/nav.php";
require_once "../../layouts/admin/sidebar.php";
?>

<!-- ------------------------------------------------ Dashboard card section ------------------------------------------------------>
<section class="bg-gray-200 shadow-md w-1/2 mx-auto overflow-hidden mt-12">
    <div class="flex items-center justify-between p-5 bg-gray-800">
        <h2 class="text-xl font-semibold text-white flex items-center gap-2">
            ایجاد حساب کاربری
        </h2>
    </div>
    <div class="p-5">
        <form action="<?= htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post" enctype="multipart/form-data">
            <input type="hidden" name="createUser" value="createUser">
            <div class="grid grid-cols-2 gap-3">
                <div class="mb-3">
                    <label class="block font-medium text-sm text-gray-700">
                        نام
                        <span class="text-red-500">*</span>
                    </label>
                    <input name="name" value="<?= $_POST['name'] ?? '' ?>" class="border-2 mt-1 block w-full border-gray-300 shadow-sm px-3 py-2" id="serial" type="text" />
                    <p class="mt-2"></p>
                </div>
                <div class="mb-3">
                    <label class="block font-medium text-sm text-gray-700">
                        نام خانوادگی
                        <span class="text-red-500">*</span>
                    </label>
                    <input name="family" value="<?= $_POST['family'] ?? '' ?>" class="border-2 mt-1 block w-full border-gray-300 shadow-sm px-3 py-2" id="price" type="text" />
                    <p class="mt-2"> </p>
                </div>
                <div class="mb-3">
                    <label class="font-medium text-sm text-gray-700 flex justify-between">
                        <span>
                            نام کاربری
                            <span class="text-red-500">*</span>
                        </span>
                        <?php if ($username_error): ?>
                            <p class="text-red-600 text-xs font-semibold"> نام کاربری تکراری است !
                            </p>
                        <?php endif; ?>
                    </label>
                    <input style="direction: ltr !important;" value="<?= $_POST['username'] ?? '' ?>" required name="username" class="border-2 mt-1 block w-full border-gray-300 shadow-sm px-3 py-2" id="weight" type="text" />

                </div>
                <div class="mb-3">
                    <label class="block font-medium text-sm text-gray-700">
                        نوعیت حساب کاربری
                        <span class="text-red-500">*</span>
                    </label>
                    <select name="type" class="border-2 p-2 text-sm mt-1 block w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 shadow-sm" id="status">
                        <option value="admin" class="text-sm">
                            مدیر
                        </option>
                        <option value="client" class="text-sm">
                            کاربر
                        </option>

                    </select>
                    <p class="mt-2"> </p>
                </div>
                <div class="mb-3 relative">
                    <label class="block font-medium text-sm text-gray-700">
                        رمزعبور
                        <span class="text-red-500">*</span>
                    </label>
                    <img onclick="togglePasswordInputType(this)" title="مشاهده/ پنهان کردن رمز عبور" src="../../public/icons/open.svg" alt="eye icon" class="material-icons cursor-pointer" style="position: absolute; left:5px; top: 50%">
                    <input required name="password" minlength="5" maxlength="50" class="border-2 mt-1 block w-full border-gray-300 shadow-sm px-3 py-2" id="mobis" type="password" />
                </div>
                <div class="mb-3">
                    <label class="block font-medium text-sm text-gray-700">
                        محدودیت درخواست روزانه
                        <span class="text-red-500">*</span>
                    </label>
                    <input name="limit" min="1" value="<?= $_POST['limit'] ?? '' ?>" class="border-2 mt-1 block w-full border-gray-300 shadow-sm px-3 py-2" id="limit" type="number" />
                    <p class="mt-2"></p>
                </div>
                <div class="flex justify-between items-center">
                    <button class="text-sm bg-sky-700 text-white py-2 px-3 hover:bg-sky-600 w-full" type="submit">ایجاد حساب کاربری</button>
                </div>

                <div class="flex items-center">
                    <?php if ($success): ?>
                        <p class="text-green-700 text-sm font-semibold">حساب کاربری موفقانه ایجاد گردید.</p>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>
</section>
<script>
    // Toggle the password field type between text and password to check inserted value.
    function togglePasswordInputType(element) {
        if (element.src.split('/').pop() == "open.svg") {
            element.src = "../../public/icons/eye.svg"
        } else {
            element.src = "../../public/icons/open.svg"
        }

        const target = element.nextElementSibling;
        const inputType = target.type;

        if (inputType === 'password') {
            target.type = 'test';
            return;
        }

        target.type = 'password';
    }
</script>
<?php
require_once "./components/footer.php";
?>