<?php
session_start();

// Check if the user is already logged in
if (isset($_SESSION["userLoggedIn"]) && $_SESSION["userLoggedIn"] === true) {
    // Check if the session has expired (current time > expiration time)
    if (isset($_SESSION["expiration_time"]) && time() > $_SESSION["expiration_time"]) {
        // Session has expired, destroy it and log the user out
        session_unset();
        session_destroy();
        header("location: login.php"); // Redirect to the login page
        exit;
    }
} else {
    // User is not logged in, redirect them to the login page
    header("location: login.php");
    exit;
}
require_once './config/config.php';
require_once './database/connect.php';
require_once('./views/Layouts/jdf.php');

date_default_timezone_set("Asia/Tehran");
$_SESSION["user_id"] = $_SESSION["id"];
?>
<!DOCTYPE html>
<html lang="fe">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="This is a simple CMS for tracing goods based on thier serail or part number.">
    <meta name="author" content="Mahdi Rezaei">
    <link rel="icon" href="./public/img/icon.png">

    <?php
    switch (basename($_SERVER['PHP_SELF'])) {
        case 'index.php':
            $title = "جستجوی اجناس";
            break;
        case 'GivenPriceHistory.php':
            $title = "تاریخچه";
            break;
        case 'givePrice.php':
            $title = "قیمت دهی دستوری";
            break;
        case 'showGoods.php':
            $title = "لیست اجناس";
            break;
        case 'showRates.php':
            $title = "لیست نرخ های ارز";
            break;
        case 'relationships.php':
            $title = "تعریف رابطه اجناس";
            break;
        case 'notification.php':
            $title = "نوتیفیکشن ها";
            break;
        case 'giveOrderedPrice.php':
            $title = "قیمت دستوری";
            break;
        case 'showPriceReports.php':
            $title = "اطلاعات کد فنی";
            break;
        default:
            $title = "سامانه یدک شاپ";
            break;
    }
    ?>
    <title><?php echo $title ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <script src="./public/js/index.js"></script>
    <link rel="stylesheet" href="./public/css/styles.css?v=<?= rand() ?>">
    <script src="./public/js/axios.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
    </script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js" integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="./public/css/select2.css">
    <script src="./public/js/select2.js"></script>
    <script src="./public/js/copy.js"></script>

<body class="font-sans antialiased">
    <div>
        <div class="min-h-screen bg-gray-100">
            <nav id="nav" ref="nav" class="main-nav bg-white shadow-lg flex flex-col justify-between">
                <i id="close" onclick="toggleNav()" class="material-icons absolute m-3 left-0 hover:cursor-pointer">close</i>
                <ul class="rtl flex flex-col pt-5 ">
                    <a class="cursor-pointer inline-flex items-center py-3 pr-6 text-sm font-medium 
                    leading-5 text-gray-500 hover:bg-indigo-500 hover:text-white focus:outline-none
                     transition duration-150 ease-in-out" href="./index.php">
                        <i class="px-2 material-icons hover:cursor-pointer">account_balance</i>
                        صفحه اصلی
                    </a>
                    <a class="cursor-pointer inline-flex items-center py-3 pr-6 text-sm 
                    font-medium leading-5 text-gray-500 hover:bg-indigo-500 hover:text-white 
                    focus:outline-none transition duration-150 ease-in-out" href="./showGoods.php">
                        <i class="px-2 material-icons hover:cursor-pointer">local_mall</i>
                        اجناس
                    </a>
                    <a class="cursor-pointer inline-flex items-center py-3 pr-6 text-sm
                     font-medium leading-5 text-gray-500 hover:bg-indigo-500 hover:text-white 
                     focus:outline-none transition duration-150 ease-in-out" href="./showRates.php">
                        <i class="px-2 material-icons hover:cursor-pointer">show_chart</i>
                        نرخ های ارز
                    </a>
                </ul>
                <!-- Authentication -->
                <a class="rtl cursor-pointer inline-flex items-center py-3 pr-6 text-sm font-medium leading-5 text-gray-500 hover:bg-indigo-500 hover:text-white focus:outline-none transition duration-150 ease-in-out" href="./logout.php">
                    <i class="px-2 material-icons hover:cursor-pointer">power_settings_new</i>
                    خروج از حساب
                </a>
            </nav>
            <!-- Page Content -->
            <main class="pt-14">
                <div class="rtl flex justify-between bg-gray-200 fixed w-full shadow-lg" style="top: 0; z-index:100">
                    <div>
                        <i class="p-2 right-0 material-icons hover:cursor-pointer fixed" onclick="toggleNav()">menu</i>
                    </div>
                    <a href="./logout.php">
                        <i class="m-2 px-2 material-icons hover:cursor-pointer">power_settings_new</i>
                    </a>
                </div>